/** @file   teleporter.h
 * @brief   Declaration of Teleporter - class.
 * @version $Revision: 1.1.1.1 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_TELEPORTER_H
#define H_WWW_TELEPORTER_H

#include <iostream>
#include <vector>
#include "gameobject.h"

namespace WeWantWar {



/** @class  Teleporter
 * @brief   Teleporters move GameObject from position to another.
 * @author  Tomi Lamminsaari
 *
 */
class Teleporter
{
public:

  ///
  /// Constants, datatype and static members
  /// ======================================


  ///
  /// Constructors, destructor and operators
  /// ======================================

	/** Constructor.
   */
	Teleporter();


	/** Destructor
   */
	virtual ~Teleporter();

private:

	/** Copy constructor.
   * @param     rO                Reference to another Teleporter
   */
  Teleporter( const Teleporter& rO );

	/** Assignment operator
   * @param     rO                Reference to another Teleporter
   * @return    Reference to us.
   */
  Teleporter& operator = ( const Teleporter& rO );

public:


  ///
  /// Methods
  /// =======

  /** Checks if the given GameObject is inside this Teleporter. If it is,
   * we teleport it to another place.
   * @param     pObj              Pointer to GameObject. Make sure you don't
   *                              pass a nullpointer.
   */
  void teleport( GameObject* pObj ) const;
  

  ///
  /// Getter methods
  /// ==============
  

  

  ///
  /// Members
  /// =======

  
  /** The target position where this teleporter teleports the objects. */
  eng2d::Vec2D  m_targetPos;
  /** The rotationangle of the object after the teleportation. */
  int m_targetAngle;

  /** This rectangle defines the area where this teleporter is located. */
  eng2d::Rect2D m_rect;

  /** The soundnumber we should make when this teleporter teleports
   * the player. -1 = no sound
   */
  int  m_makeSound;
  
  /** An id-number of this teleporter. */
  int m_id;

private:

  ///
  /// Private members
  /// ===============

};

};  // end of namespace

#endif

/**
 * Version history
 * ===============
 * $Log: teleporter.h,v $
 * Revision 1.1.1.1  2006/01/21 23:02:42  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:17:18+02  lamminsa
 * Initial revision
 *
 */
 
